// ExtIRQDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ExtIRQ.h"
#include "ExtIRQDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CExtIRQDlg dialog

CExtIRQDlg::CExtIRQDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CExtIRQDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CExtIRQDlg)
	m_DlinxStatus = _T("");
	m_deviceNumber = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CExtIRQDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExtIRQDlg)
	DDX_Text(pDX, IDC_STATUS, m_DlinxStatus);
	DDX_Text(pDX, IDC_DEVNUM, m_deviceNumber);
	DDV_MinMaxUInt(pDX, m_deviceNumber, 0, 5);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CExtIRQDlg, CDialog)
	//{{AFX_MSG_MAP(CExtIRQDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_OPEN, OnOpen)
	ON_BN_CLICKED(IDC_ENABLE, OnEnable)
	ON_BN_CLICKED(IDC_DISABLE, OnDisable)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExtIRQDlg message handlers

BOOL CExtIRQDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_driverInstance = NULL;
	m_pSR = NULL;
	IrqCounter = 0;
	m_deviceNumber = 0;
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CExtIRQDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CExtIRQDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CExtIRQDlg::showMessage(DL_ServiceRequest *SR)
{
	if(SR->result != NoErr)
	{
		SR->operation=MESSAGEBOX;
		DriverLINX(SR);
	}
}

void CExtIRQDlg::OnOpen() 
{
		// open the driver; pass in driver name to avoid the OpenDriver dialog
	// could use the desktop window handle if making a console app
	m_driverInstance=OpenDriverLINX(m_hWnd,"kmbctm");
	// allocate the SR structure and init all members to zero
	m_pSR=(DL_ServiceRequest*)new DL_ServiceRequest;
	memset(m_pSR,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*m_pSR);

	m_DLmsg=RegisterWindowMessage(DL_MESSAGE); //need to register DriverLINX messages

	// read in device number from the dialog
	UpdateData(TRUE);

	// initialize the board belonging to the opened driver
	m_pSR->operation=INITIALIZE;
	m_pSR->device=m_deviceNumber;   // device number must agree with one assigned in DLinx Config Panel
	m_pSR->mode=OTHER;
	m_pSR->subsystem=DEVICE;
	m_pSR->hWnd=m_hWnd;
	DriverLINX(m_pSR);
	showMessage(m_pSR);
 
	CExtIRQDlg::SetActiveWindow();  // return focus to our Dialog

	
}

void CExtIRQDlg::OnEnable() 
{
	// set up the SR to send message if rising edge at IRQ (pin 1) occurs
	m_pSR->operation=START;
	m_pSR->subsystem=CT;
	m_pSR->mode=INTERRUPT;
	m_pSR->start.typeEvent=COMMAND;
	m_pSR->stop.typeEvent=COMMAND;

	m_pSR->timing.typeEvent=DIEVENT;
	m_pSR->timing.u.diEvent.channel = DI_EXTCLK;  // external IRQ line
	// DI_EXTCLK has value of 2 if CTM-10; 1 if CTM-05.  See ctmguide.pdf
	m_pSR->timing.u.diEvent.mask = 1;   // a 1-bit compare
	m_pSR->timing.u.diEvent.match = 0;  //NotEquals
	m_pSR->timing.u.diEvent.pattern = 0;  // 0 = rising edge

	m_pSR->channels.nChannels = 1;
	m_pSR->channels.chanGain[0].channel = 0;
	m_pSR->channels.numberFormat = tNATIVE;

	m_pSR->lpBuffers=(DL_BUFFERLIST*) new BYTE[DL_BufferListBytes(1)];
//create a buffer list pointer for one buffer
	m_pSR->lpBuffers->nBuffers=1; //use only one buffer
m_pSR->lpBuffers->bufferSize=Samples2Bytes(0,CT,0,1);
                                  //m_logicalDevice,subSystem,m_logicalChannel,m_samples
//set the size of the buffer (in bytes) to hold the number of samples
m_pSR->lpBuffers->BufferAddr[0]=BufAlloc(GBUF_INT,m_pSR->lpBuffers->bufferSize); 
//Allocate Buffer 0 based on the size we just specified


	DriverLINX(m_pSR);  // start the task
	showMessage(m_pSR); // error check

	m_DlinxStatus.Format("%s","Waiting for Rising Edge at AINT");
	UpdateData(FALSE);
/*
This example was tested in Win2KSP4 with a CTM-05/A board using
CTM-850A01.0.0.2 version of DriverLINX and VC++ 6

The IRQ Enable line must be pulled low AND a rising edge at the
IRQ Request line must occur.  These are labeled as AENB and AINT
in the CTM user's guide, Appendix B.
*/
	
}

void CExtIRQDlg::OnDisable() 
{
	// do a stop operation to disable the task
	m_pSR->operation=STOP;
	DriverLINX(m_pSR);
	showMessage(m_pSR);

	m_DlinxStatus.Format("%s","IRQ Detection Disabled by Request");
	UpdateData(FALSE);

	// dispose here of the memory buffer allocated in the START operation
	clearBuffers(m_pSR);
	
}

void CExtIRQDlg::OnOK() 
{
	// free memory used by the SR structure
	clearBuffers(m_pSR);
	if (m_driverInstance != NULL)
		{
		CloseDriverLINX(m_driverInstance);
		m_driverInstance=NULL;
		}
	if (m_pSR != NULL)
		{
		delete m_pSR;
		m_pSR=NULL;
		}
	
	CDialog::OnOK();
}

LRESULT CExtIRQDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(message==m_DLmsg)
	//Did DriverLINX post a message? We only want to act on the DriverLINX buffer filled message
	{
	switch(wParam)
		{
		case DL_BUFFERFILLED: //Was the DriverLINX message the buffer filled message?
		IrqCounter++;
		CString msg;
		char message[40];
		strcpy(message,"Edge Detection Count: ");
		msg.Format("%d",IrqCounter);
		strcat(message,msg);  // tack ticCounter onto end of message
		strcat(message," times");
		m_DlinxStatus.Format("%s",message);
		UpdateData(FALSE);  // update the dialog
		break;
		}
	}
	return CDialog::WindowProc(message, wParam, lParam);
}

void CExtIRQDlg::clearBuffers(DL_ServiceRequest *SR)
{
	if(SR!=NULL)
	{ if(SR->lpBuffers!=NULL)
		{
		// Expand as necessary, to clear more than 1 buffer
		if(SR->lpBuffers->BufferAddr[0]!=NULL)
		{
		BufFree(SR->lpBuffers->BufferAddr[0]);
		SR->lpBuffers->BufferAddr[0]=NULL;
		}
		delete(SR->lpBuffers);
		SR->lpBuffers=NULL;
		}
	}
}
